/**
 * 
 */
package com.ejie.ab18a.security;

import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;

import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.security.XlnetCore;
import com.ejie.x38.util.StaticsContainer;

/**
 * @author XXXX
 * 
 */
public class Ab18aPerimetralSecurityWrapperImpl implements PerimetralSecurityWrapper {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aPerimetralSecurityWrapperImpl.class);

	/** The xlnet caching period. */
	private Long xlnetCachingPeriod;

	/**
	 * Instantiates a new ab18a perimetral security wrapper impl.
	 */
	public Ab18aPerimetralSecurityWrapperImpl() {
	}

	/**
	 * Validate session.
	 * 
	 * @param httpRequest
	 *            the http request
	 * @return the n38 api
	 */
	private N38API validateSession(HttpServletRequest httpRequest) {
		Ab18aPerimetralSecurityWrapperImpl.logger.info("Refreshing XLNET session!");
		N38API n38Api = XlnetCore.getN38API(httpRequest);
		Document xmlSecurity = XlnetCore.getN38ItemSesion(n38Api);
		if (XlnetCore.isXlnetSessionContainingErrors(xmlSecurity) || XlnetCore.isXlnetSessionContainingWarnings(xmlSecurity)) {
			xmlSecurity = null;
			return null;
		} else {
			return n38Api;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.x38.security.PerimetralSecurityWrapper#getUserConnectedUserName
	 * (javax.servlet.http.HttpServletRequest)
	 */
	@Override()
	public String getUserConnectedUserName(HttpServletRequest httpRequest) {
		String result = null;
		if (this.isXlnetCachingActive(httpRequest) && httpRequest.getSession(false) != null
				&& httpRequest.getSession(false).getAttribute("UserName") != null) {
			result = (String) httpRequest.getSession(false).getAttribute("UserName");
			Ab18aPerimetralSecurityWrapperImpl.logger.debug((new StringBuilder("Obtained the userName of the request: ")).append(result).toString());
			Ab18aPerimetralSecurityWrapperImpl.logger.info((new StringBuilder("The incoming user \"")).append(result)
					.append("\" is already authenticated in the security system").toString());
		} else {

			if (httpRequest.getSession(false).getAttribute("Position") == null && httpRequest.getSession(false).getAttribute("UidSession") == null
					&& httpRequest.getSession(false).getAttribute("UserProfiles") == null && this.validateSession(httpRequest) == null) {
				SecurityContextHolder.clearContext();
				// throw new AuthenticationCredentialsNotFoundException(
				// "The XLNET session is invalid or the Xlnet's user isn't logger");
				return "";
			}
			N38API n38Api = XlnetCore.getN38API(httpRequest);
			if (n38Api != null) {
				result = XlnetCore.getLogin(n38Api);
			}
			if (result != null) {
				Ab18aPerimetralSecurityWrapperImpl.logger.trace((new StringBuilder("Connected User's Name is: ")).append(result).toString());
			} else {
				Ab18aPerimetralSecurityWrapperImpl.logger.warn("Connected User's Name is null!");
				return null;
			}
			if (httpRequest.getSession(false) != null) {
				httpRequest.getSession(false).setAttribute("UserName", result);
			}
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.x38.security.PerimetralSecurityWrapper#getUserPosition(javax
	 * .servlet.http.HttpServletRequest)
	 */
	@Override()
	public String getUserPosition(HttpServletRequest httpRequest) {
		String result = null;
		if (this.isXlnetCachingActive(httpRequest) && httpRequest.getSession(false) != null
				&& httpRequest.getSession(false).getAttribute("Position") != null) {
			result = (String) httpRequest.getSession(false).getAttribute("Position");
		} else {
			if (httpRequest.getSession(false).getAttribute("UserName") == null && httpRequest.getSession(false).getAttribute("UidSession") == null
					&& httpRequest.getSession(false).getAttribute("UserProfiles") == null && this.validateSession(httpRequest) == null) {
				// Y46jPerimetralSecurityWrapperImpl.logger
				// .error("The XLNET session is invalid or the Xlnet's user isn't logger. Proceeding to cle"
				// + "an the Security Context Holder.");
				SecurityContextHolder.clearContext();
				throw new AuthenticationCredentialsNotFoundException(
				// "The XLNET session is invalid or the Xlnet's user isn't logger");
						"");
				// return "";
			}
			N38API n38Api = XlnetCore.getN38API(httpRequest);
			if (n38Api != null) {
				result = XlnetCore.getPuesto(n38Api);
			}
			if (result != null) {
				Ab18aPerimetralSecurityWrapperImpl.logger.trace((new StringBuilder("Connected User's Position is: ")).append(result).toString());
			} else {
				Ab18aPerimetralSecurityWrapperImpl.logger.warn("Connected User's Position is null!");
				return null;
			}
			if (httpRequest.getSession(false) != null) {
				httpRequest.getSession(false).setAttribute("Position", result);
			}
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.x38.security.PerimetralSecurityWrapper#getUserConnectedUidSession
	 * (javax.servlet.http.HttpServletRequest)
	 */
	@Override()
	public String getUserConnectedUidSession(HttpServletRequest httpRequest) {
		String result = null;
		if (this.isXlnetCachingActive(httpRequest) && httpRequest.getSession(false) != null
				&& httpRequest.getSession(false).getAttribute("UidSession") != null) {
			result = (String) httpRequest.getSession(false).getAttribute("UidSession");
		} else {
			if (httpRequest.getSession(false).getAttribute("Position") == null && httpRequest.getSession(false).getAttribute("UserName") == null
					&& httpRequest.getSession(false).getAttribute("UserProfiles") == null && this.validateSession(httpRequest) == null) {
				// Y46jPerimetralSecurityWrapperImpl.logger
				// .error("The XLNET session is invalid or the Xlnet's user isn't logger. Proceeding to cle"
				// + "an the Security Context Holder.");
				SecurityContextHolder.clearContext();
				// throw new AuthenticationCredentialsNotFoundException(
				// "The XLNET session is invalid or the Xlnet's user isn't logger");
				return "";
			}
			N38API n38Api = XlnetCore.getN38API(httpRequest);
			if (n38Api != null) {
				result = XlnetCore.getUidSesion(n38Api);
			}
			if (result != null) {
				Ab18aPerimetralSecurityWrapperImpl.logger.trace((new StringBuilder("Connected UserConnectedUidSession is: ")).append(result)
						.toString());
			} else {
				Ab18aPerimetralSecurityWrapperImpl.logger.warn("Connected UserConnectedUidSession is null!");
				return null;
			}
			if (httpRequest.getSession(false) != null) {
				httpRequest.getSession(false).setAttribute("UidSession", result);
			}
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.x38.security.PerimetralSecurityWrapper#getUserInstances(javax
	 * .servlet.http.HttpServletRequest)
	 */
	@Override()
	public Vector getUserInstances(HttpServletRequest httpRequest) {

		Vector result = null;

		if (this.isXlnetCachingActive(httpRequest) && httpRequest.getSession(false) != null
				&& httpRequest.getSession(false).getAttribute("UserProfiles") != null) {
			result = (Vector) httpRequest.getSession(false).getAttribute("UserProfiles");
		} else {
			if (httpRequest.getSession(false).getAttribute("Position") == null && httpRequest.getSession(false).getAttribute("UserName") == null
					&& httpRequest.getSession(false).getAttribute("UidSession") != null && this.validateSession(httpRequest) == null) {
				// Y46jPerimetralSecurityWrapperImpl.logger
				// .error("The XLNET session is invalid or the Xlnet's user isn't logger. Proceeding to cle"
				// + "an the Security Context Holder.");
				SecurityContextHolder.clearContext();
				// throw new AuthenticationCredentialsNotFoundException(
				// "The XLNET session is invalid or the Xlnet's user isn't logger");
				return null;
			}
			N38API n38Api = XlnetCore.getN38API(httpRequest);
			Document xmlSecurity = null;
			if (n38Api != null) {
				xmlSecurity = XlnetCore.getN38ItemSeguridad(n38Api, StaticsContainer.webAppName);
				if (xmlSecurity != null) {
					result = XlnetCore.searchParameterIntoXlnetSesion(xmlSecurity,
							"/n38/elementos/elemento/elemento/elemento/parametro[@id='n38uidobjseguridad']/va" + "lor");
				}
				xmlSecurity = null;
			}
			if (result != null) {
				Ab18aPerimetralSecurityWrapperImpl.logger.trace((new StringBuilder("Connected UserProfiles are: ")).append(result).toString());
			} else {
				Ab18aPerimetralSecurityWrapperImpl.logger.warn("Connected UserProfiles is null!");
				return null;
			}
			if (httpRequest.getSession(false) != null) {
				httpRequest.getSession(false).setAttribute("UserProfiles", result);
			}
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.x38.security.PerimetralSecurityWrapper#getURLLogin(java.lang
	 * .String)
	 */
	public String getURLLogin(String originalURL) {
		Ab18aPerimetralSecurityWrapperImpl.logger.debug((new StringBuilder("Original URLLogin is :")).append(originalURL).toString());
		StringBuilder resultURL = new StringBuilder(StaticsContainer.loginUrl);
		if (originalURL != null && !"".equals(originalURL)) {
			resultURL.append("?N38API=");
			resultURL.append(originalURL);
		}
		Ab18aPerimetralSecurityWrapperImpl.logger.debug((new StringBuilder("URLLogin is: ")).append(resultURL).toString());
		return resultURL.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.x38.security.PerimetralSecurityWrapper#logout(javax.servlet.
	 * http.HttpServletRequest)
	 */
	public void logout(HttpServletRequest httpRequest) {
		String uidSession = this.getUserConnectedUidSession(httpRequest);
		Ab18aPerimetralSecurityWrapperImpl.logger.info((new StringBuilder("Proceeding to destroy uidSession: ")).append(uidSession).toString());
		N38APISesion n38ApiSesion = new N38APISesion();
		n38ApiSesion.n38APISesionDestruir(uidSession);
		Ab18aPerimetralSecurityWrapperImpl.logger.info((new StringBuilder("Session ")).append(uidSession).append(" destroyed!").toString());
	}

	/**
	 * Checks if is xlnet caching active.
	 * 
	 * @param httpRequest
	 *            the http request
	 * @return true, if is xlnet caching active
	 */
	private boolean isXlnetCachingActive(HttpServletRequest httpRequest) {
		boolean caching = true;

		// If the sessionId changed, disable XLNET caching
		if (httpRequest.getSession(false) != null) {

			// XLNets retrieve n38UidSesionGlobal cookie
			Cookie requestCookies[] = httpRequest.getCookies();
			String n38UidSesion = null;
			String n38UidSistemasXLNetS = null;
			StringBuilder udaXLNetsSessionId = new StringBuilder();

			if (requestCookies != null) {
				for (int i = 0; i < requestCookies.length; i++) {
					if (requestCookies[i].getName().equals("n38UidSesion")) {
						n38UidSesion = requestCookies[i].getValue();
					} else if (requestCookies[i].getName().equals("n38UidSistemasXLNetS")) {
						n38UidSistemasXLNetS = requestCookies[i].getValue();
					}
				}
			}

			udaXLNetsSessionId.append(n38UidSistemasXLNetS);
			udaXLNetsSessionId.append("-");
			udaXLNetsSessionId.append(n38UidSesion);

			if (n38UidSesion != null && n38UidSistemasXLNetS != null) {
				if (httpRequest.getSession(false).getAttribute("udaXLNetsSessionId") != null) {
					if (!(httpRequest.getSession(false).getAttribute("udaXLNetsSessionId").equals(udaXLNetsSessionId.toString()))) {
						httpRequest.getSession(false).setAttribute("udaTimeStamp", System.currentTimeMillis());

						// It clears the cache of XLNets
						this.xlnetCleanCache(httpRequest);

						Ab18aPerimetralSecurityWrapperImpl.logger.debug("Caching of session " + httpRequest.getSession(false).getId()
								+ " expired, because the XLNets user has changed");
						httpRequest.getSession(false).setAttribute("reloadData", "true");
						caching = false;

						httpRequest.getSession(false).setAttribute("udaXLNetsSessionId", udaXLNetsSessionId.toString());
					}
				} else {
					httpRequest.getSession(false).setAttribute("udaXLNetsSessionId", udaXLNetsSessionId.toString());
				}
			}

			udaXLNetsSessionId = null;
		}
		// If the last XLNET session refresh was performed more than X minutes
		// ago, disable caching
		if (httpRequest.getSession(false) != null && httpRequest.getSession(false).getAttribute("udaTimeStamp") != null) {
			if ((System.currentTimeMillis() - Long.valueOf(httpRequest.getSession(false).getAttribute("udaTimeStamp") + "")) > TimeUnit.MILLISECONDS
					.convert(this.xlnetCachingPeriod.longValue(), TimeUnit.SECONDS)) {

				// httpRequest.getSession(false).setAttribute("udaTimeStamp",
				// System.currentTimeMillis());

				// It clears the cache of XLNets
				// xlnetCleanCache(httpRequest);

				// httpRequest.getSession(false).setAttribute("reloadData",
				// "true");

				Ab18aPerimetralSecurityWrapperImpl.logger.debug("Caching of session " + httpRequest.getSession(false).getId()
						+ " expired, after, at least, " + this.xlnetCachingPeriod + " Seconds");
				// caching = false;
			}
		}
		// If the session is new, disable XLNET caching
		if (httpRequest.getSession(false) != null && (Boolean) httpRequest.getSession(false).getAttribute("udaVirgin")) {
			httpRequest.getSession(false).setAttribute("udaVirgin", Boolean.FALSE);
			httpRequest.getSession(false).setAttribute("udaTimeStamp", System.currentTimeMillis());

			// It clears the cache of XLNets
			this.xlnetCleanCache(httpRequest);

			Ab18aPerimetralSecurityWrapperImpl.logger.debug("Session " + httpRequest.getSession(false).getId() + " is new");
			caching = false;
		}
		// If the session does not exist, disable XLNET caching
		if (httpRequest.getSession(false) == null) {
			httpRequest.getSession(true);
			Ab18aPerimetralSecurityWrapperImpl.logger.debug("Session " + httpRequest.getSession(false).getId() + " created");
			caching = false;
		}

		return caching;
	}

	/**
	 * Gets the xlnet caching period.
	 * 
	 * @return the xlnet caching period
	 */
	public Long getXlnetCachingPeriod() {
		return this.xlnetCachingPeriod;
	}

	/**
	 * Sets the xlnet caching period.
	 * 
	 * @param xlnetCachingPeriod
	 *            the new xlnet caching period
	 */
	public void setXlnetCachingPeriod(Long xlnetCachingPeriod) {
		this.xlnetCachingPeriod = xlnetCachingPeriod;
	}

	/**
	 * Xlnet clean cache.
	 * 
	 * @param httpRequest
	 *            the http request
	 */
	private void xlnetCleanCache(HttpServletRequest httpRequest) {
		HttpSession session = httpRequest.getSession(false);
		session.removeAttribute("UserName");
		session.removeAttribute("Position");
		session.removeAttribute("UidSession");
		session.removeAttribute("UserProfiles");
	}

	@Override
	public Credentials getCredentials() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean getDestroySessionSecuritySystem() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean getIsCertificate(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public String getNif(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getPolicy(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getURLLogin(String arg0, boolean arg1) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getUdaValidateSessionId(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public HashMap<String, String> getUserDataInfo(HttpServletRequest arg0, boolean arg1) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void logout(HttpServletRequest arg0, HttpServletResponse arg1) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setDestroySessionSecuritySystem(boolean arg0) {
		// TODO Auto-generated method stub

	}

	@Override
	public String validateSession(HttpServletRequest arg0, HttpServletResponse arg1) throws SecurityException {
		// TODO Auto-generated method stub
		return null;
	}
}
